package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  IAMAccessKeyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AccessKey(
    accessKeyId: Option[IAMAccessKeyId] = None,
    secretAccessKey: Option[NonEmptyString] = None,
    status: Option[zio.aws.lightsail.model.StatusType] = None,
    createdAt: Option[IsoDate] = None,
    lastUsed: Option[zio.aws.lightsail.model.AccessKeyLastUsed] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccessKey = {
    import AccessKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessKey
      .builder()
      .optionallyWith(
        accessKeyId.map(value => IAMAccessKeyId.unwrap(value): java.lang.String)
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastUsed.map(value => value.buildAwsValue()))(_.lastUsed)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AccessKey.ReadOnly =
    zio.aws.lightsail.model.AccessKey.wrap(buildAwsValue())
}
object AccessKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccessKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AccessKey =
      zio.aws.lightsail.model.AccessKey(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        lastUsed.map(value => value.asEditable)
      )
    def accessKeyId: Option[IAMAccessKeyId]
    def secretAccessKey: Option[NonEmptyString]
    def status: Option[zio.aws.lightsail.model.StatusType]
    def createdAt: Option[IsoDate]
    def lastUsed: Option[zio.aws.lightsail.model.AccessKeyLastUsed.ReadOnly]
    def getAccessKeyId: ZIO[Any, AwsError, IAMAccessKeyId] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getStatus: ZIO[Any, AwsError, zio.aws.lightsail.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUsed: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.AccessKeyLastUsed.ReadOnly
    ] = AwsError.unwrapOptionField("lastUsed", lastUsed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKey
  ) extends zio.aws.lightsail.model.AccessKey.ReadOnly {
    override val accessKeyId: Option[IAMAccessKeyId] = scala
      .Option(impl.accessKeyId())
      .map(value => zio.aws.lightsail.model.primitives.IAMAccessKeyId(value))
    override val secretAccessKey: Option[NonEmptyString] = scala
      .Option(impl.secretAccessKey())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val status: Option[zio.aws.lightsail.model.StatusType] = scala
      .Option(impl.status())
      .map(value => zio.aws.lightsail.model.StatusType.wrap(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val lastUsed
        : Option[zio.aws.lightsail.model.AccessKeyLastUsed.ReadOnly] = scala
      .Option(impl.lastUsed())
      .map(value => zio.aws.lightsail.model.AccessKeyLastUsed.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKey
  ): zio.aws.lightsail.model.AccessKey.ReadOnly = new Wrapper(impl)
}
