package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.IsoDate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AccessKeyLastUsed(
    lastUsedDate: Option[IsoDate] = None,
    region: Option[String] = None,
    serviceName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed = {
    import AccessKeyLastUsed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
      .builder()
      .optionallyWith(
        lastUsedDate.map(value => IsoDate.unwrap(value): Instant)
      )(_.lastUsedDate)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AccessKeyLastUsed.ReadOnly =
    zio.aws.lightsail.model.AccessKeyLastUsed.wrap(buildAwsValue())
}
object AccessKeyLastUsed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AccessKeyLastUsed =
      zio.aws.lightsail.model.AccessKeyLastUsed(
        lastUsedDate.map(value => value),
        region.map(value => value),
        serviceName.map(value => value)
      )
    def lastUsedDate: Option[IsoDate]
    def region: Option[String]
    def serviceName: Option[String]
    def getLastUsedDate: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("lastUsedDate", lastUsedDate)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
  ) extends zio.aws.lightsail.model.AccessKeyLastUsed.ReadOnly {
    override val lastUsedDate: Option[IsoDate] = scala
      .Option(impl.lastUsedDate())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val region: Option[String] =
      scala.Option(impl.region()).map(value => value: String)
    override val serviceName: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed
  ): zio.aws.lightsail.model.AccessKeyLastUsed.ReadOnly = new Wrapper(impl)
}
