package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  Integer,
  MetricPeriod,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Alarm(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    supportCode: Option[String] = None,
    monitoredResourceInfo: Option[
      zio.aws.lightsail.model.MonitoredResourceInfo
    ] = None,
    comparisonOperator: Option[zio.aws.lightsail.model.ComparisonOperator] =
      None,
    evaluationPeriods: Option[Integer] = None,
    period: Option[MetricPeriod] = None,
    threshold: Option[Double] = None,
    datapointsToAlarm: Option[Integer] = None,
    treatMissingData: Option[zio.aws.lightsail.model.TreatMissingData] = None,
    statistic: Option[zio.aws.lightsail.model.MetricStatistic] = None,
    metricName: Option[zio.aws.lightsail.model.MetricName] = None,
    state: Option[zio.aws.lightsail.model.AlarmState] = None,
    unit: Option[zio.aws.lightsail.model.MetricUnit] = None,
    contactProtocols: Option[
      Iterable[zio.aws.lightsail.model.ContactProtocol]
    ] = None,
    notificationTriggers: Option[Iterable[zio.aws.lightsail.model.AlarmState]] =
      None,
    notificationEnabled: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Alarm
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(
        monitoredResourceInfo.map(value => value.buildAwsValue())
      )(_.monitoredResourceInfo)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(evaluationPeriods.map(value => value: java.lang.Integer))(
        _.evaluationPeriods
      )
      .optionallyWith(
        period.map(value => MetricPeriod.unwrap(value): java.lang.Integer)
      )(_.period)
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(treatMissingData.map(value => value.unwrap))(
        _.treatMissingData
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        contactProtocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contactProtocolsWithStrings)
      .optionallyWith(
        notificationTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationTriggersWithStrings)
      .optionallyWith(
        notificationEnabled.map(value => value: java.lang.Boolean)
      )(_.notificationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Alarm.ReadOnly =
    zio.aws.lightsail.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Alarm] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Alarm =
      zio.aws.lightsail.model.Alarm(
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        supportCode.map(value => value),
        monitoredResourceInfo.map(value => value.asEditable),
        comparisonOperator.map(value => value),
        evaluationPeriods.map(value => value),
        period.map(value => value),
        threshold.map(value => value),
        datapointsToAlarm.map(value => value),
        treatMissingData.map(value => value),
        statistic.map(value => value),
        metricName.map(value => value),
        state.map(value => value),
        unit.map(value => value),
        contactProtocols.map(value => value),
        notificationTriggers.map(value => value),
        notificationEnabled.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def supportCode: Option[String]
    def monitoredResourceInfo
        : Option[zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly]
    def comparisonOperator: Option[zio.aws.lightsail.model.ComparisonOperator]
    def evaluationPeriods: Option[Integer]
    def period: Option[MetricPeriod]
    def threshold: Option[Double]
    def datapointsToAlarm: Option[Integer]
    def treatMissingData: Option[zio.aws.lightsail.model.TreatMissingData]
    def statistic: Option[zio.aws.lightsail.model.MetricStatistic]
    def metricName: Option[zio.aws.lightsail.model.MetricName]
    def state: Option[zio.aws.lightsail.model.AlarmState]
    def unit: Option[zio.aws.lightsail.model.MetricUnit]
    def contactProtocols: Option[List[zio.aws.lightsail.model.ContactProtocol]]
    def notificationTriggers: Option[List[zio.aws.lightsail.model.AlarmState]]
    def notificationEnabled: Option[Boolean]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getMonitoredResourceInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly
    ] =
      AwsError.unwrapOptionField("monitoredResourceInfo", monitoredResourceInfo)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getEvaluationPeriods: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getPeriod: ZIO[Any, AwsError, MetricPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getThreshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getDatapointsToAlarm: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarm)
    def getTreatMissingData
        : ZIO[Any, AwsError, zio.aws.lightsail.model.TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingData)
    def getStatistic
        : ZIO[Any, AwsError, zio.aws.lightsail.model.MetricStatistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getMetricName: ZIO[Any, AwsError, zio.aws.lightsail.model.MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.AlarmState] =
      AwsError.unwrapOptionField("state", state)
    def getUnit: ZIO[Any, AwsError, zio.aws.lightsail.model.MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getContactProtocols
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.ContactProtocol]] =
      AwsError.unwrapOptionField("contactProtocols", contactProtocols)
    def getNotificationTriggers
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AlarmState]] =
      AwsError.unwrapOptionField("notificationTriggers", notificationTriggers)
    def getNotificationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notificationEnabled", notificationEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Alarm
  ) extends zio.aws.lightsail.model.Alarm.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val monitoredResourceInfo
        : Option[zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly] = scala
      .Option(impl.monitoredResourceInfo())
      .map(value => zio.aws.lightsail.model.MonitoredResourceInfo.wrap(value))
    override val comparisonOperator
        : Option[zio.aws.lightsail.model.ComparisonOperator] = scala
      .Option(impl.comparisonOperator())
      .map(value => zio.aws.lightsail.model.ComparisonOperator.wrap(value))
    override val evaluationPeriods: Option[Integer] =
      scala.Option(impl.evaluationPeriods()).map(value => value: Integer)
    override val period: Option[MetricPeriod] = scala
      .Option(impl.period())
      .map(value => zio.aws.lightsail.model.primitives.MetricPeriod(value))
    override val threshold: Option[Double] =
      scala.Option(impl.threshold()).map(value => value: Double)
    override val datapointsToAlarm: Option[Integer] =
      scala.Option(impl.datapointsToAlarm()).map(value => value: Integer)
    override val treatMissingData
        : Option[zio.aws.lightsail.model.TreatMissingData] = scala
      .Option(impl.treatMissingData())
      .map(value => zio.aws.lightsail.model.TreatMissingData.wrap(value))
    override val statistic: Option[zio.aws.lightsail.model.MetricStatistic] =
      scala
        .Option(impl.statistic())
        .map(value => zio.aws.lightsail.model.MetricStatistic.wrap(value))
    override val metricName: Option[zio.aws.lightsail.model.MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.lightsail.model.MetricName.wrap(value))
    override val state: Option[zio.aws.lightsail.model.AlarmState] = scala
      .Option(impl.state())
      .map(value => zio.aws.lightsail.model.AlarmState.wrap(value))
    override val unit: Option[zio.aws.lightsail.model.MetricUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.lightsail.model.MetricUnit.wrap(value))
    override val contactProtocols
        : Option[List[zio.aws.lightsail.model.ContactProtocol]] = scala
      .Option(impl.contactProtocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ContactProtocol.wrap(item)
        }.toList
      )
    override val notificationTriggers
        : Option[List[zio.aws.lightsail.model.AlarmState]] = scala
      .Option(impl.notificationTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.AlarmState.wrap(item)
        }.toList
      )
    override val notificationEnabled: Option[Boolean] =
      scala.Option(impl.notificationEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Alarm
  ): zio.aws.lightsail.model.Alarm.ReadOnly = new Wrapper(impl)
}
