package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait AlarmState {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AlarmState
}
object AlarmState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AlarmState
  ): zio.aws.lightsail.model.AlarmState = value match {
    case software.amazon.awssdk.services.lightsail.model.AlarmState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AlarmState.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.lightsail.model.AlarmState.ALARM =>
      val r = ALARM
      r
    case software.amazon.awssdk.services.lightsail.model.AlarmState.INSUFFICIENT_DATA =>
      val r = INSUFFICIENT_DATA
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.AlarmState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AlarmState =
      software.amazon.awssdk.services.lightsail.model.AlarmState.UNKNOWN_TO_SDK_VERSION
  }
  case object OK extends zio.aws.lightsail.model.AlarmState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AlarmState =
      software.amazon.awssdk.services.lightsail.model.AlarmState.OK
  }
  case object ALARM extends zio.aws.lightsail.model.AlarmState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AlarmState =
      software.amazon.awssdk.services.lightsail.model.AlarmState.ALARM
  }
  case object INSUFFICIENT_DATA extends zio.aws.lightsail.model.AlarmState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AlarmState =
      software.amazon.awssdk.services.lightsail.model.AlarmState.INSUFFICIENT_DATA
  }
}
