package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachCertificateToDistributionRequest(
    distributionName: ResourceName,
    certificateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest = {
    import AttachCertificateToDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
      .builder()
      .distributionName(ResourceName.unwrap(distributionName): java.lang.String)
      .certificateName(ResourceName.unwrap(certificateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.AttachCertificateToDistributionRequest.ReadOnly =
    zio.aws.lightsail.model.AttachCertificateToDistributionRequest
      .wrap(buildAwsValue())
}
object AttachCertificateToDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.AttachCertificateToDistributionRequest =
      zio.aws.lightsail.model.AttachCertificateToDistributionRequest(
        distributionName,
        certificateName
      )
    def distributionName: ResourceName
    def certificateName: ResourceName
    def getDistributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionName)
    def getCertificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
  ) extends zio.aws.lightsail.model.AttachCertificateToDistributionRequest.ReadOnly {
    override val distributionName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.distributionName())
    override val certificateName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.certificateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest
  ): zio.aws.lightsail.model.AttachCertificateToDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
