package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachCertificateToDistributionResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse = {
    import AttachCertificateToDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly =
    zio.aws.lightsail.model.AttachCertificateToDistributionResponse
      .wrap(buildAwsValue())
}
object AttachCertificateToDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.AttachCertificateToDistributionResponse =
      zio.aws.lightsail.model.AttachCertificateToDistributionResponse(
        operation.map(value => value.asEditable)
      )
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse
  ) extends zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse
  ): zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
