package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachDiskRequest(
    diskName: ResourceName,
    instanceName: ResourceName,
    diskPath: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachDiskRequest = {
    import AttachDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .diskPath(NonEmptyString.unwrap(diskPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AttachDiskRequest.ReadOnly =
    zio.aws.lightsail.model.AttachDiskRequest.wrap(buildAwsValue())
}
object AttachDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AttachDiskRequest =
      zio.aws.lightsail.model
        .AttachDiskRequest(diskName, instanceName, diskPath)
    def diskName: ResourceName
    def instanceName: ResourceName
    def diskPath: NonEmptyString
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getDiskPath: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(diskPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
  ) extends zio.aws.lightsail.model.AttachDiskRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val diskPath: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.diskPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
  ): zio.aws.lightsail.model.AttachDiskRequest.ReadOnly = new Wrapper(impl)
}
