package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachStaticIpRequest(
    staticIpName: ResourceName,
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest = {
    import AttachStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
      .builder()
      .staticIpName(ResourceName.unwrap(staticIpName): java.lang.String)
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AttachStaticIpRequest.ReadOnly =
    zio.aws.lightsail.model.AttachStaticIpRequest.wrap(buildAwsValue())
}
object AttachStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AttachStaticIpRequest =
      zio.aws.lightsail.model.AttachStaticIpRequest(staticIpName, instanceName)
    def staticIpName: ResourceName
    def instanceName: ResourceName
    def getStaticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpName)
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
  ) extends zio.aws.lightsail.model.AttachStaticIpRequest.ReadOnly {
    override val staticIpName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.staticIpName())
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest
  ): zio.aws.lightsail.model.AttachStaticIpRequest.ReadOnly = new Wrapper(impl)
}
