package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AttachedDisk(
    path: Option[String] = None,
    sizeInGb: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachedDisk = {
    import AttachedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachedDisk
      .builder()
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AttachedDisk.ReadOnly =
    zio.aws.lightsail.model.AttachedDisk.wrap(buildAwsValue())
}
object AttachedDisk {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachedDisk
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AttachedDisk =
      zio.aws.lightsail.model
        .AttachedDisk(path.map(value => value), sizeInGb.map(value => value))
    def path: Option[String]
    def sizeInGb: Option[Integer]
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachedDisk
  ) extends zio.aws.lightsail.model.AttachedDisk.ReadOnly {
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val sizeInGb: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachedDisk
  ): zio.aws.lightsail.model.AttachedDisk.ReadOnly = new Wrapper(impl)
}
