package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.IsoDate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AutoSnapshotDetails(
    date: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    status: Option[zio.aws.lightsail.model.AutoSnapshotStatus] = None,
    fromAttachedDisks: Option[Iterable[zio.aws.lightsail.model.AttachedDisk]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails = {
    import AutoSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
      .builder()
      .optionallyWith(date.map(value => value: java.lang.String))(_.date)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromAttachedDisks)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly =
    zio.aws.lightsail.model.AutoSnapshotDetails.wrap(buildAwsValue())
}
object AutoSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AutoSnapshotDetails =
      zio.aws.lightsail.model.AutoSnapshotDetails(
        date.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def date: Option[String]
    def createdAt: Option[IsoDate]
    def status: Option[zio.aws.lightsail.model.AutoSnapshotStatus]
    def fromAttachedDisks
        : Option[List[zio.aws.lightsail.model.AttachedDisk.ReadOnly]]
    def getDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("date", date)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AutoSnapshotStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFromAttachedDisks: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AttachedDisk.ReadOnly
    ]] = AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ) extends zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly {
    override val date: Option[String] =
      scala.Option(impl.date()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val status: Option[zio.aws.lightsail.model.AutoSnapshotStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lightsail.model.AutoSnapshotStatus.wrap(value))
    override val fromAttachedDisks
        : Option[List[zio.aws.lightsail.model.AttachedDisk.ReadOnly]] = scala
      .Option(impl.fromAttachedDisks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.AttachedDisk.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ): zio.aws.lightsail.model.AutoSnapshotDetails.ReadOnly = new Wrapper(impl)
}
