package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait AutoSnapshotStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus
}
object AutoSnapshotStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus
  ): zio.aws.lightsail.model.AutoSnapshotStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.NOT_FOUND =>
      val r = NotFound
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.AutoSnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus =
      software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Success extends zio.aws.lightsail.model.AutoSnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus =
      software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.SUCCESS
  }
  case object Failed extends zio.aws.lightsail.model.AutoSnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus =
      software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.FAILED
  }
  case object InProgress extends zio.aws.lightsail.model.AutoSnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus =
      software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.IN_PROGRESS
  }
  case object NotFound extends zio.aws.lightsail.model.AutoSnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus =
      software.amazon.awssdk.services.lightsail.model.AutoSnapshotStatus.NOT_FOUND
  }
}
