package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AvailabilityZone(
    zoneName: Option[NonEmptyString] = None,
    state: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AvailabilityZone
      .builder()
      .optionallyWith(
        zoneName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.zoneName)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AvailabilityZone.ReadOnly =
    zio.aws.lightsail.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AvailabilityZone =
      zio.aws.lightsail.model.AvailabilityZone(
        zoneName.map(value => value),
        state.map(value => value)
      )
    def zoneName: Option[NonEmptyString]
    def state: Option[NonEmptyString]
    def getZoneName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("zoneName", zoneName)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AvailabilityZone
  ) extends zio.aws.lightsail.model.AvailabilityZone.ReadOnly {
    override val zoneName: Option[NonEmptyString] = scala
      .Option(impl.zoneName())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val state: Option[NonEmptyString] = scala
      .Option(impl.state())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AvailabilityZone
  ): zio.aws.lightsail.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
