package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Blueprint(
    blueprintId: Option[NonEmptyString] = None,
    name: Option[ResourceName] = None,
    group: Option[NonEmptyString] = None,
    `type`: Option[zio.aws.lightsail.model.BlueprintType] = None,
    description: Option[String] = None,
    isActive: Option[Boolean] = None,
    minPower: Option[Integer] = None,
    version: Option[String] = None,
    versionCode: Option[String] = None,
    productUrl: Option[String] = None,
    licenseUrl: Option[String] = None,
    platform: Option[zio.aws.lightsail.model.InstancePlatform] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Blueprint = {
    import Blueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Blueprint
      .builder()
      .optionallyWith(
        blueprintId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.blueprintId)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        group.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .optionallyWith(minPower.map(value => value: java.lang.Integer))(
        _.minPower
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(versionCode.map(value => value: java.lang.String))(
        _.versionCode
      )
      .optionallyWith(productUrl.map(value => value: java.lang.String))(
        _.productUrl
      )
      .optionallyWith(licenseUrl.map(value => value: java.lang.String))(
        _.licenseUrl
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Blueprint.ReadOnly =
    zio.aws.lightsail.model.Blueprint.wrap(buildAwsValue())
}
object Blueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Blueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Blueprint =
      zio.aws.lightsail.model.Blueprint(
        blueprintId.map(value => value),
        name.map(value => value),
        group.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        isActive.map(value => value),
        minPower.map(value => value),
        version.map(value => value),
        versionCode.map(value => value),
        productUrl.map(value => value),
        licenseUrl.map(value => value),
        platform.map(value => value)
      )
    def blueprintId: Option[NonEmptyString]
    def name: Option[ResourceName]
    def group: Option[NonEmptyString]
    def `type`: Option[zio.aws.lightsail.model.BlueprintType]
    def description: Option[String]
    def isActive: Option[Boolean]
    def minPower: Option[Integer]
    def version: Option[String]
    def versionCode: Option[String]
    def productUrl: Option[String]
    def licenseUrl: Option[String]
    def platform: Option[zio.aws.lightsail.model.InstancePlatform]
    def getBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintId", blueprintId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("group", group)
    def getType: ZIO[Any, AwsError, zio.aws.lightsail.model.BlueprintType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getMinPower: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minPower", minPower)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getVersionCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionCode", versionCode)
    def getProductUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productUrl", productUrl)
    def getLicenseUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrl)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstancePlatform] =
      AwsError.unwrapOptionField("platform", platform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Blueprint
  ) extends zio.aws.lightsail.model.Blueprint.ReadOnly {
    override val blueprintId: Option[NonEmptyString] = scala
      .Option(impl.blueprintId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val group: Option[NonEmptyString] = scala
      .Option(impl.group())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val `type`: Option[zio.aws.lightsail.model.BlueprintType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.lightsail.model.BlueprintType.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val isActive: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
    override val minPower: Option[Integer] =
      scala.Option(impl.minPower()).map(value => value: Integer)
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val versionCode: Option[String] =
      scala.Option(impl.versionCode()).map(value => value: String)
    override val productUrl: Option[String] =
      scala.Option(impl.productUrl()).map(value => value: String)
    override val licenseUrl: Option[String] =
      scala.Option(impl.licenseUrl()).map(value => value: String)
    override val platform: Option[zio.aws.lightsail.model.InstancePlatform] =
      scala
        .Option(impl.platform())
        .map(value => zio.aws.lightsail.model.InstancePlatform.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Blueprint
  ): zio.aws.lightsail.model.Blueprint.ReadOnly = new Wrapper(impl)
}
