package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{BucketName, IsoDate, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Bucket(
    resourceType: Option[NonEmptyString] = None,
    accessRules: Option[zio.aws.lightsail.model.AccessRules] = None,
    arn: Option[NonEmptyString] = None,
    bundleId: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    url: Option[NonEmptyString] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    name: Option[BucketName] = None,
    supportCode: Option[NonEmptyString] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    objectVersioning: Option[NonEmptyString] = None,
    ableToUpdateBundle: Option[Boolean] = None,
    readonlyAccessAccounts: Option[Iterable[NonEmptyString]] = None,
    resourcesReceivingAccess: Option[
      Iterable[zio.aws.lightsail.model.ResourceReceivingAccess]
    ] = None,
    state: Option[zio.aws.lightsail.model.BucketState] = None,
    accessLogConfig: Option[zio.aws.lightsail.model.BucketAccessLogConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bucket
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(accessRules.map(value => value.buildAwsValue()))(
        _.accessRules
      )
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        supportCode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.supportCode)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        objectVersioning.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.objectVersioning)
      .optionallyWith(
        ableToUpdateBundle.map(value => value: java.lang.Boolean)
      )(_.ableToUpdateBundle)
      .optionallyWith(
        readonlyAccessAccounts.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readonlyAccessAccounts)
      .optionallyWith(
        resourcesReceivingAccess.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesReceivingAccess)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(accessLogConfig.map(value => value.buildAwsValue()))(
        _.accessLogConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Bucket.ReadOnly =
    zio.aws.lightsail.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Bucket =
      zio.aws.lightsail.model.Bucket(
        resourceType.map(value => value),
        accessRules.map(value => value.asEditable),
        arn.map(value => value),
        bundleId.map(value => value),
        createdAt.map(value => value),
        url.map(value => value),
        location.map(value => value.asEditable),
        name.map(value => value),
        supportCode.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectVersioning.map(value => value),
        ableToUpdateBundle.map(value => value),
        readonlyAccessAccounts.map(value => value),
        resourcesReceivingAccess.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value.asEditable),
        accessLogConfig.map(value => value.asEditable)
      )
    def resourceType: Option[NonEmptyString]
    def accessRules: Option[zio.aws.lightsail.model.AccessRules.ReadOnly]
    def arn: Option[NonEmptyString]
    def bundleId: Option[NonEmptyString]
    def createdAt: Option[IsoDate]
    def url: Option[NonEmptyString]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def name: Option[BucketName]
    def supportCode: Option[NonEmptyString]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def objectVersioning: Option[NonEmptyString]
    def ableToUpdateBundle: Option[Boolean]
    def readonlyAccessAccounts: Option[List[NonEmptyString]]
    def resourcesReceivingAccess
        : Option[List[zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly]]
    def state: Option[zio.aws.lightsail.model.BucketState.ReadOnly]
    def accessLogConfig
        : Option[zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly]
    def getResourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAccessRules
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AccessRules.ReadOnly] =
      AwsError.unwrapOptionField("accessRules", accessRules)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getSupportCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getObjectVersioning: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectVersioning", objectVersioning)
    def getAbleToUpdateBundle: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundle)
    def getReadonlyAccessAccounts: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readonlyAccessAccounts",
        readonlyAccessAccounts
      )
    def getResourcesReceivingAccess: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourcesReceivingAccess",
      resourcesReceivingAccess
    )
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.BucketState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getAccessLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogConfig", accessLogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Bucket
  ) extends zio.aws.lightsail.model.Bucket.ReadOnly {
    override val resourceType: Option[NonEmptyString] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val accessRules
        : Option[zio.aws.lightsail.model.AccessRules.ReadOnly] = scala
      .Option(impl.accessRules())
      .map(value => zio.aws.lightsail.model.AccessRules.wrap(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val bundleId: Option[NonEmptyString] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val url: Option[NonEmptyString] = scala
      .Option(impl.url())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val name: Option[BucketName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.BucketName(value))
    override val supportCode: Option[NonEmptyString] = scala
      .Option(impl.supportCode())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val objectVersioning: Option[NonEmptyString] = scala
      .Option(impl.objectVersioning())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val ableToUpdateBundle: Option[Boolean] =
      scala.Option(impl.ableToUpdateBundle()).map(value => value: Boolean)
    override val readonlyAccessAccounts: Option[List[NonEmptyString]] = scala
      .Option(impl.readonlyAccessAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val resourcesReceivingAccess: Option[
      List[zio.aws.lightsail.model.ResourceReceivingAccess.ReadOnly]
    ] = scala
      .Option(impl.resourcesReceivingAccess())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ResourceReceivingAccess.wrap(item)
        }.toList
      )
    override val state: Option[zio.aws.lightsail.model.BucketState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.lightsail.model.BucketState.wrap(value))
    override val accessLogConfig
        : Option[zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly] = scala
      .Option(impl.accessLogConfig())
      .map(value => zio.aws.lightsail.model.BucketAccessLogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Bucket
  ): zio.aws.lightsail.model.Bucket.ReadOnly = new Wrapper(impl)
}
