package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{BucketAccessLogPrefix, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BucketAccessLogConfig(
    enabled: Boolean,
    destination: Option[BucketName] = None,
    prefix: Option[BucketAccessLogPrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig = {
    import BucketAccessLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        destination.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(
        prefix.map(value =>
          BucketAccessLogPrefix.unwrap(value): java.lang.String
        )
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly =
    zio.aws.lightsail.model.BucketAccessLogConfig.wrap(buildAwsValue())
}
object BucketAccessLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.BucketAccessLogConfig =
      zio.aws.lightsail.model.BucketAccessLogConfig(
        enabled,
        destination.map(value => value),
        prefix.map(value => value)
      )
    def enabled: Boolean
    def destination: Option[BucketName]
    def prefix: Option[BucketAccessLogPrefix]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getDestination: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("destination", destination)
    def getPrefix: ZIO[Any, AwsError, BucketAccessLogPrefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ) extends zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val destination: Option[BucketName] = scala
      .Option(impl.destination())
      .map(value => zio.aws.lightsail.model.primitives.BucketName(value))
    override val prefix: Option[BucketAccessLogPrefix] = scala
      .Option(impl.prefix())
      .map(value =>
        zio.aws.lightsail.model.primitives.BucketAccessLogPrefix(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ): zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly = new Wrapper(impl)
}
