package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BucketState(
    code: Option[NonEmptyString] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketState = {
    import BucketState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketState
      .builder()
      .optionallyWith(
        code.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.BucketState.ReadOnly =
    zio.aws.lightsail.model.BucketState.wrap(buildAwsValue())
}
object BucketState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.BucketState =
      zio.aws.lightsail.model
        .BucketState(code.map(value => value), message.map(value => value))
    def code: Option[NonEmptyString]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketState
  ) extends zio.aws.lightsail.model.BucketState.ReadOnly {
    override val code: Option[NonEmptyString] = scala
      .Option(impl.code())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketState
  ): zio.aws.lightsail.model.BucketState.ReadOnly = new Wrapper(impl)
}
