package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheSettings(
    defaultTTL: Option[Long] = None,
    minimumTTL: Option[Long] = None,
    maximumTTL: Option[Long] = None,
    allowedHTTPMethods: Option[NonEmptyString] = None,
    cachedHTTPMethods: Option[NonEmptyString] = None,
    forwardedCookies: Option[zio.aws.lightsail.model.CookieObject] = None,
    forwardedHeaders: Option[zio.aws.lightsail.model.HeaderObject] = None,
    forwardedQueryStrings: Option[zio.aws.lightsail.model.QueryStringObject] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CacheSettings = {
    import CacheSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheSettings
      .builder()
      .optionallyWith(defaultTTL.map(value => value: java.lang.Long))(
        _.defaultTTL
      )
      .optionallyWith(minimumTTL.map(value => value: java.lang.Long))(
        _.minimumTTL
      )
      .optionallyWith(maximumTTL.map(value => value: java.lang.Long))(
        _.maximumTTL
      )
      .optionallyWith(
        allowedHTTPMethods.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.allowedHTTPMethods)
      .optionallyWith(
        cachedHTTPMethods.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cachedHTTPMethods)
      .optionallyWith(forwardedCookies.map(value => value.buildAwsValue()))(
        _.forwardedCookies
      )
      .optionallyWith(forwardedHeaders.map(value => value.buildAwsValue()))(
        _.forwardedHeaders
      )
      .optionallyWith(
        forwardedQueryStrings.map(value => value.buildAwsValue())
      )(_.forwardedQueryStrings)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CacheSettings.ReadOnly =
    zio.aws.lightsail.model.CacheSettings.wrap(buildAwsValue())
}
object CacheSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CacheSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CacheSettings =
      zio.aws.lightsail.model.CacheSettings(
        defaultTTL.map(value => value),
        minimumTTL.map(value => value),
        maximumTTL.map(value => value),
        allowedHTTPMethods.map(value => value),
        cachedHTTPMethods.map(value => value),
        forwardedCookies.map(value => value.asEditable),
        forwardedHeaders.map(value => value.asEditable),
        forwardedQueryStrings.map(value => value.asEditable)
      )
    def defaultTTL: Option[Long]
    def minimumTTL: Option[Long]
    def maximumTTL: Option[Long]
    def allowedHTTPMethods: Option[NonEmptyString]
    def cachedHTTPMethods: Option[NonEmptyString]
    def forwardedCookies: Option[zio.aws.lightsail.model.CookieObject.ReadOnly]
    def forwardedHeaders: Option[zio.aws.lightsail.model.HeaderObject.ReadOnly]
    def forwardedQueryStrings
        : Option[zio.aws.lightsail.model.QueryStringObject.ReadOnly]
    def getDefaultTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultTTL", defaultTTL)
    def getMinimumTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minimumTTL", minimumTTL)
    def getMaximumTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maximumTTL", maximumTTL)
    def getAllowedHTTPMethods: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("allowedHTTPMethods", allowedHTTPMethods)
    def getCachedHTTPMethods: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cachedHTTPMethods", cachedHTTPMethods)
    def getForwardedCookies
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CookieObject.ReadOnly] =
      AwsError.unwrapOptionField("forwardedCookies", forwardedCookies)
    def getForwardedHeaders
        : ZIO[Any, AwsError, zio.aws.lightsail.model.HeaderObject.ReadOnly] =
      AwsError.unwrapOptionField("forwardedHeaders", forwardedHeaders)
    def getForwardedQueryStrings: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.QueryStringObject.ReadOnly
    ] =
      AwsError.unwrapOptionField("forwardedQueryStrings", forwardedQueryStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CacheSettings
  ) extends zio.aws.lightsail.model.CacheSettings.ReadOnly {
    override val defaultTTL: Option[Long] =
      scala.Option(impl.defaultTTL()).map(value => value: Long)
    override val minimumTTL: Option[Long] =
      scala.Option(impl.minimumTTL()).map(value => value: Long)
    override val maximumTTL: Option[Long] =
      scala.Option(impl.maximumTTL()).map(value => value: Long)
    override val allowedHTTPMethods: Option[NonEmptyString] = scala
      .Option(impl.allowedHTTPMethods())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val cachedHTTPMethods: Option[NonEmptyString] = scala
      .Option(impl.cachedHTTPMethods())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val forwardedCookies
        : Option[zio.aws.lightsail.model.CookieObject.ReadOnly] = scala
      .Option(impl.forwardedCookies())
      .map(value => zio.aws.lightsail.model.CookieObject.wrap(value))
    override val forwardedHeaders
        : Option[zio.aws.lightsail.model.HeaderObject.ReadOnly] = scala
      .Option(impl.forwardedHeaders())
      .map(value => zio.aws.lightsail.model.HeaderObject.wrap(value))
    override val forwardedQueryStrings
        : Option[zio.aws.lightsail.model.QueryStringObject.ReadOnly] = scala
      .Option(impl.forwardedQueryStrings())
      .map(value => zio.aws.lightsail.model.QueryStringObject.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CacheSettings
  ): zio.aws.lightsail.model.CacheSettings.ReadOnly = new Wrapper(impl)
}
