package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloseInstancePublicPortsRequest(
    portInfo: zio.aws.lightsail.model.PortInfo,
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest = {
    import CloseInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
      .builder()
      .portInfo(portInfo.buildAwsValue())
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CloseInstancePublicPortsRequest.ReadOnly =
    zio.aws.lightsail.model.CloseInstancePublicPortsRequest
      .wrap(buildAwsValue())
}
object CloseInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CloseInstancePublicPortsRequest =
      zio.aws.lightsail.model
        .CloseInstancePublicPortsRequest(portInfo.asEditable, instanceName)
    def portInfo: zio.aws.lightsail.model.PortInfo.ReadOnly
    def instanceName: ResourceName
    def getPortInfo
        : ZIO[Any, Nothing, zio.aws.lightsail.model.PortInfo.ReadOnly] =
      ZIO.succeed(portInfo)
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
  ) extends zio.aws.lightsail.model.CloseInstancePublicPortsRequest.ReadOnly {
    override val portInfo: zio.aws.lightsail.model.PortInfo.ReadOnly =
      zio.aws.lightsail.model.PortInfo.wrap(impl.portInfo())
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
  ): zio.aws.lightsail.model.CloseInstancePublicPortsRequest.ReadOnly =
    new Wrapper(impl)
}
