package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ContactMethod(
    contactEndpoint: Option[NonEmptyString] = None,
    status: Option[zio.aws.lightsail.model.ContactMethodStatus] = None,
    protocol: Option[zio.aws.lightsail.model.ContactProtocol] = None,
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    supportCode: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContactMethod = {
    import ContactMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContactMethod
      .builder()
      .optionallyWith(
        contactEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.contactEndpoint)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContactMethod.ReadOnly =
    zio.aws.lightsail.model.ContactMethod.wrap(buildAwsValue())
}
object ContactMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContactMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContactMethod =
      zio.aws.lightsail.model.ContactMethod(
        contactEndpoint.map(value => value),
        status.map(value => value),
        protocol.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        supportCode.map(value => value)
      )
    def contactEndpoint: Option[NonEmptyString]
    def status: Option[zio.aws.lightsail.model.ContactMethodStatus]
    def protocol: Option[zio.aws.lightsail.model.ContactProtocol]
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def supportCode: Option[String]
    def getContactEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contactEndpoint", contactEndpoint)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContactMethodStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContactProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContactMethod
  ) extends zio.aws.lightsail.model.ContactMethod.ReadOnly {
    override val contactEndpoint: Option[NonEmptyString] = scala
      .Option(impl.contactEndpoint())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val status: Option[zio.aws.lightsail.model.ContactMethodStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lightsail.model.ContactMethodStatus.wrap(value))
    override val protocol: Option[zio.aws.lightsail.model.ContactProtocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.lightsail.model.ContactProtocol.wrap(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContactMethod
  ): zio.aws.lightsail.model.ContactMethod.ReadOnly = new Wrapper(impl)
}
