package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait ContactProtocol {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ContactProtocol
}
object ContactProtocol {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ContactProtocol
  ): zio.aws.lightsail.model.ContactProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.ContactProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContactProtocol.EMAIL =>
      val r = Email
      r
    case software.amazon.awssdk.services.lightsail.model.ContactProtocol.SMS =>
      val r = SMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ContactProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContactProtocol =
      software.amazon.awssdk.services.lightsail.model.ContactProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object Email extends zio.aws.lightsail.model.ContactProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContactProtocol =
      software.amazon.awssdk.services.lightsail.model.ContactProtocol.EMAIL
  }
  case object SMS extends zio.aws.lightsail.model.ContactProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContactProtocol =
      software.amazon.awssdk.services.lightsail.model.ContactProtocol.SMS
  }
}
