package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Container(
    image: Option[String] = None,
    command: Option[Iterable[String]] = None,
    environment: Option[Map[String, String]] = None,
    ports: Option[
      Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Container
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(
        ports.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.portsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Container.ReadOnly =
    zio.aws.lightsail.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Container
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Container =
      zio.aws.lightsail.model.Container(
        image.map(value => value),
        command.map(value => value),
        environment.map(value => value),
        ports.map(value => value)
      )
    def image: Option[String]
    def command: Option[List[String]]
    def environment: Option[Map[String, String]]
    def ports
        : Option[Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getEnvironment: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("environment", environment)
    def getPorts: ZIO[Any, AwsError, Map[
      String,
      zio.aws.lightsail.model.ContainerServiceProtocol
    ]] = AwsError.unwrapOptionField("ports", ports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Container
  ) extends zio.aws.lightsail.model.Container.ReadOnly {
    override val image: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override val command: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val environment: Option[Map[String, String]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val ports: Option[
      Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]
    ] = scala
      .Option(impl.ports())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.lightsail.model.ContainerServiceProtocol
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Container
  ): zio.aws.lightsail.model.Container.ReadOnly = new Wrapper(impl)
}
