package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{IsoDate, ContainerName, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ContainerServiceDeployment(
    version: Option[Integer] = None,
    state: Option[zio.aws.lightsail.model.ContainerServiceDeploymentState] =
      None,
    containers: Option[Map[ContainerName, zio.aws.lightsail.model.Container]] =
      None,
    publicEndpoint: Option[zio.aws.lightsail.model.ContainerServiceEndpoint] =
      None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment = {
    import ContainerServiceDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
      .builder()
      .optionallyWith(version.map(value => value: java.lang.Integer))(_.version)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        containers.map(value =>
          value
            .map({ case (key, value) =>
              (ContainerName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.containers)
      .optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(
        _.publicEndpoint
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceDeployment.wrap(buildAwsValue())
}
object ContainerServiceDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceDeployment =
      zio.aws.lightsail.model.ContainerServiceDeployment(
        version.map(value => value),
        state.map(value => value),
        containers.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        publicEndpoint.map(value => value.asEditable),
        createdAt.map(value => value)
      )
    def version: Option[Integer]
    def state: Option[zio.aws.lightsail.model.ContainerServiceDeploymentState]
    def containers
        : Option[Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]]
    def publicEndpoint
        : Option[zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly]
    def createdAt: Option[IsoDate]
    def getVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("version", version)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeploymentState
    ] = AwsError.unwrapOptionField("state", state)
    def getContainers: ZIO[Any, AwsError, Map[
      ContainerName,
      zio.aws.lightsail.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getPublicEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("publicEndpoint", publicEndpoint)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ) extends zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly {
    override val version: Option[Integer] =
      scala.Option(impl.version()).map(value => value: Integer)
    override val state
        : Option[zio.aws.lightsail.model.ContainerServiceDeploymentState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceDeploymentState.wrap(value)
        )
    override val containers: Option[
      Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]
    ] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.primitives.ContainerName(
              key
            ) -> zio.aws.lightsail.model.Container.wrap(value)
          })
          .toMap
      )
    override val publicEndpoint
        : Option[zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly] =
      scala
        .Option(impl.publicEndpoint())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceEndpoint.wrap(value)
        )
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment
  ): zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly = new Wrapper(
    impl
  )
}
