package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServicePower(
    powerId: Option[String] = None,
    price: Option[Float] = None,
    cpuCount: Option[Float] = None,
    ramSizeInGb: Option[Float] = None,
    name: Option[String] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServicePower = {
    import ContainerServicePower.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower
      .builder()
      .optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(cpuCount.map(value => value: java.lang.Float))(_.cpuCount)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServicePower.ReadOnly =
    zio.aws.lightsail.model.ContainerServicePower.wrap(buildAwsValue())
}
object ContainerServicePower {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServicePower =
      zio.aws.lightsail.model.ContainerServicePower(
        powerId.map(value => value),
        price.map(value => value),
        cpuCount.map(value => value),
        ramSizeInGb.map(value => value),
        name.map(value => value),
        isActive.map(value => value)
      )
    def powerId: Option[String]
    def price: Option[Float]
    def cpuCount: Option[Float]
    def ramSizeInGb: Option[Float]
    def name: Option[String]
    def isActive: Option[Boolean]
    def getPowerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("powerId", powerId)
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getCpuCount: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ) extends zio.aws.lightsail.model.ContainerServicePower.ReadOnly {
    override val powerId: Option[String] =
      scala.Option(impl.powerId()).map(value => value: String)
    override val price: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override val cpuCount: Option[Float] =
      scala.Option(impl.cpuCount()).map(value => value: Float)
    override val ramSizeInGb: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val isActive: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ): zio.aws.lightsail.model.ContainerServicePower.ReadOnly = new Wrapper(impl)
}
