package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerServicePowerName {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName
}
object ContainerServicePowerName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName
  ): zio.aws.lightsail.model.ContainerServicePowerName = value match {
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.NANO =>
      val r = nano
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.MICRO =>
      val r = micro
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.SMALL =>
      val r = small
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.MEDIUM =>
      val r = medium
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.LARGE =>
      val r = large
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.XLARGE =>
      val r = xlarge
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.UNKNOWN_TO_SDK_VERSION
  }
  case object nano extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.NANO
  }
  case object micro extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.MICRO
  }
  case object small extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.SMALL
  }
  case object medium extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.MEDIUM
  }
  case object large extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.LARGE
  }
  case object xlarge extends zio.aws.lightsail.model.ContainerServicePowerName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName =
      software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName.XLARGE
  }
}
