package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.IsoDate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ContainerServiceRegistryLogin(
    username: Option[String] = None,
    password: Option[String] = None,
    expiresAt: Option[IsoDate] = None,
    registry: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin = {
    import ContainerServiceRegistryLogin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(expiresAt.map(value => IsoDate.unwrap(value): Instant))(
        _.expiresAt
      )
      .optionallyWith(registry.map(value => value: java.lang.String))(
        _.registry
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceRegistryLogin.wrap(buildAwsValue())
}
object ContainerServiceRegistryLogin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceRegistryLogin =
      zio.aws.lightsail.model.ContainerServiceRegistryLogin(
        username.map(value => value),
        password.map(value => value),
        expiresAt.map(value => value),
        registry.map(value => value)
      )
    def username: Option[String]
    def password: Option[String]
    def expiresAt: Option[IsoDate]
    def registry: Option[String]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("password", password)
    def getExpiresAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
    def getRegistry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registry", registry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ) extends zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly {
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val password: Option[String] =
      scala.Option(impl.password()).map(value => value: String)
    override val expiresAt: Option[IsoDate] = scala
      .Option(impl.expiresAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val registry: Option[String] =
      scala.Option(impl.registry()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin
  ): zio.aws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly =
    new Wrapper(impl)
}
