package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketRequest(
    bucketName: BucketName,
    bundleId: NonEmptyString,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    enableObjectVersioning: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .bundleId(NonEmptyString.unwrap(bundleId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableObjectVersioning.map(value => value: java.lang.Boolean)
      )(_.enableObjectVersioning)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateBucketRequest.ReadOnly =
    zio.aws.lightsail.model.CreateBucketRequest.wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateBucketRequest =
      zio.aws.lightsail.model.CreateBucketRequest(
        bucketName,
        bundleId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableObjectVersioning.map(value => value)
      )
    def bucketName: BucketName
    def bundleId: NonEmptyString
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def enableObjectVersioning: Option[Boolean]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableObjectVersioning: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableObjectVersioning", enableObjectVersioning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
  ) extends zio.aws.lightsail.model.CreateBucketRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val bundleId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.bundleId())
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val enableObjectVersioning: Option[Boolean] =
      scala.Option(impl.enableObjectVersioning()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketRequest
  ): zio.aws.lightsail.model.CreateBucketRequest.ReadOnly = new Wrapper(impl)
}
