package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateBucketResponse(
    bucket: Option[zio.aws.lightsail.model.Bucket] = None,
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketResponse = {
    import CreateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
      .builder()
      .optionallyWith(bucket.map(value => value.buildAwsValue()))(_.bucket)
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateBucketResponse.ReadOnly =
    zio.aws.lightsail.model.CreateBucketResponse.wrap(buildAwsValue())
}
object CreateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateBucketResponse =
      zio.aws.lightsail.model.CreateBucketResponse(
        bucket.map(value => value.asEditable),
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bucket: Option[zio.aws.lightsail.model.Bucket.ReadOnly]
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getBucket: ZIO[Any, AwsError, zio.aws.lightsail.model.Bucket.ReadOnly] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
  ) extends zio.aws.lightsail.model.CreateBucketResponse.ReadOnly {
    override val bucket: Option[zio.aws.lightsail.model.Bucket.ReadOnly] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.lightsail.model.Bucket.wrap(value))
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketResponse
  ): zio.aws.lightsail.model.CreateBucketResponse.ReadOnly = new Wrapper(impl)
}
