package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCertificateResponse(
    certificate: Option[zio.aws.lightsail.model.CertificateSummary] = None,
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse = {
    import CreateCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly =
    zio.aws.lightsail.model.CreateCertificateResponse.wrap(buildAwsValue())
}
object CreateCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateCertificateResponse =
      zio.aws.lightsail.model.CreateCertificateResponse(
        certificate.map(value => value.asEditable),
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificate: Option[zio.aws.lightsail.model.CertificateSummary.ReadOnly]
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.CertificateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificate)
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
  ) extends zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly {
    override val certificate
        : Option[zio.aws.lightsail.model.CertificateSummary.ReadOnly] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.lightsail.model.CertificateSummary.wrap(value))
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
  ): zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
