package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCloudFormationStackRequest(
    instances: Iterable[zio.aws.lightsail.model.InstanceEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest = {
    import CreateCloudFormationStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
      .builder()
      .instances(instances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateCloudFormationStackRequest.ReadOnly =
    zio.aws.lightsail.model.CreateCloudFormationStackRequest
      .wrap(buildAwsValue())
}
object CreateCloudFormationStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateCloudFormationStackRequest =
      zio.aws.lightsail.model.CreateCloudFormationStackRequest(instances.map {
        item =>
          item.asEditable
      })
    def instances: List[zio.aws.lightsail.model.InstanceEntry.ReadOnly]
    def getInstances: ZIO[Any, Nothing, List[
      zio.aws.lightsail.model.InstanceEntry.ReadOnly
    ]] = ZIO.succeed(instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
  ) extends zio.aws.lightsail.model.CreateCloudFormationStackRequest.ReadOnly {
    override val instances
        : List[zio.aws.lightsail.model.InstanceEntry.ReadOnly] = impl
      .instances()
      .asScala
      .map { item =>
        zio.aws.lightsail.model.InstanceEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
  ): zio.aws.lightsail.model.CreateCloudFormationStackRequest.ReadOnly =
    new Wrapper(impl)
}
