package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ContainerName, ContainerServiceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceDeploymentRequest(
    serviceName: ContainerServiceName,
    containers: Option[Map[ContainerName, zio.aws.lightsail.model.Container]] =
      None,
    publicEndpoint: Option[zio.aws.lightsail.model.EndpointRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest = {
    import CreateContainerServiceDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .optionallyWith(
        containers.map(value =>
          value
            .map({ case (key, value) =>
              (ContainerName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.containers)
      .optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(
        _.publicEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateContainerServiceDeploymentRequest.ReadOnly =
    zio.aws.lightsail.model.CreateContainerServiceDeploymentRequest
      .wrap(buildAwsValue())
}
object CreateContainerServiceDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateContainerServiceDeploymentRequest =
      zio.aws.lightsail.model.CreateContainerServiceDeploymentRequest(
        serviceName,
        containers.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        publicEndpoint.map(value => value.asEditable)
      )
    def serviceName: ContainerServiceName
    def containers
        : Option[Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]]
    def publicEndpoint: Option[zio.aws.lightsail.model.EndpointRequest.ReadOnly]
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getContainers: ZIO[Any, AwsError, Map[
      ContainerName,
      zio.aws.lightsail.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getPublicEndpoint
        : ZIO[Any, AwsError, zio.aws.lightsail.model.EndpointRequest.ReadOnly] =
      AwsError.unwrapOptionField("publicEndpoint", publicEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
  ) extends zio.aws.lightsail.model.CreateContainerServiceDeploymentRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val containers: Option[
      Map[ContainerName, zio.aws.lightsail.model.Container.ReadOnly]
    ] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lightsail.model.primitives.ContainerName(
              key
            ) -> zio.aws.lightsail.model.Container.wrap(value)
          })
          .toMap
      )
    override val publicEndpoint
        : Option[zio.aws.lightsail.model.EndpointRequest.ReadOnly] = scala
      .Option(impl.publicEndpoint())
      .map(value => zio.aws.lightsail.model.EndpointRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest
  ): zio.aws.lightsail.model.CreateContainerServiceDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
