package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceDeploymentResponse(
    containerService: Option[zio.aws.lightsail.model.ContainerService] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse = {
    import CreateContainerServiceDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
      .builder()
      .optionallyWith(containerService.map(value => value.buildAwsValue()))(
        _.containerService
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly =
    zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse
      .wrap(buildAwsValue())
}
object CreateContainerServiceDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse =
      zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse(
        containerService.map(value => value.asEditable)
      )
    def containerService
        : Option[zio.aws.lightsail.model.ContainerService.ReadOnly]
    def getContainerService: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerService.ReadOnly
    ] = AwsError.unwrapOptionField("containerService", containerService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
  ) extends zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly {
    override val containerService
        : Option[zio.aws.lightsail.model.ContainerService.ReadOnly] = scala
      .Option(impl.containerService())
      .map(value => zio.aws.lightsail.model.ContainerService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
  ): zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly =
    new Wrapper(impl)
}
