package zio.aws.lightsail.model
import java.lang.Integer
import zio.aws.lightsail.model.primitives.{
  ContainerServiceScale,
  ContainerServiceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceRequest(
    serviceName: ContainerServiceName,
    power: zio.aws.lightsail.model.ContainerServicePowerName,
    scale: ContainerServiceScale,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    publicDomainNames: Option[Map[String, Iterable[String]]] = None,
    deployment: Option[
      zio.aws.lightsail.model.ContainerServiceDeploymentRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest = {
    import CreateContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .power(power.unwrap)
      .scale(ContainerServiceScale.unwrap(scale): Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .optionallyWith(deployment.map(value => value.buildAwsValue()))(
        _.deployment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateContainerServiceRequest.ReadOnly =
    zio.aws.lightsail.model.CreateContainerServiceRequest.wrap(buildAwsValue())
}
object CreateContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateContainerServiceRequest =
      zio.aws.lightsail.model.CreateContainerServiceRequest(
        serviceName,
        power,
        scale,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publicDomainNames.map(value => value),
        deployment.map(value => value.asEditable)
      )
    def serviceName: ContainerServiceName
    def power: zio.aws.lightsail.model.ContainerServicePowerName
    def scale: ContainerServiceScale
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def publicDomainNames: Option[Map[String, List[String]]]
    def deployment: Option[
      zio.aws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly
    ]
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getPower
        : ZIO[Any, Nothing, zio.aws.lightsail.model.ContainerServicePowerName] =
      ZIO.succeed(power)
    def getScale: ZIO[Any, Nothing, ContainerServiceScale] = ZIO.succeed(scale)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPublicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNames)
    def getDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly
    ] = AwsError.unwrapOptionField("deployment", deployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
  ) extends zio.aws.lightsail.model.CreateContainerServiceRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val power: zio.aws.lightsail.model.ContainerServicePowerName =
      zio.aws.lightsail.model.ContainerServicePowerName.wrap(impl.power())
    override val scale: ContainerServiceScale =
      zio.aws.lightsail.model.primitives.ContainerServiceScale(impl.scale())
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val publicDomainNames: Option[Map[String, List[String]]] = scala
      .Option(impl.publicDomainNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val deployment: Option[
      zio.aws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly
    ] = scala
      .Option(impl.deployment())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceDeploymentRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
  ): zio.aws.lightsail.model.CreateContainerServiceRequest.ReadOnly =
    new Wrapper(impl)
}
