package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDistributionRequest(
    distributionName: ResourceName,
    origin: zio.aws.lightsail.model.InputOrigin,
    defaultCacheBehavior: zio.aws.lightsail.model.CacheBehavior,
    cacheBehaviorSettings: Option[zio.aws.lightsail.model.CacheSettings] = None,
    cacheBehaviors: Option[
      Iterable[zio.aws.lightsail.model.CacheBehaviorPerPath]
    ] = None,
    bundleId: String,
    ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest = {
    import CreateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
      .builder()
      .distributionName(ResourceName.unwrap(distributionName): java.lang.String)
      .origin(origin.buildAwsValue())
      .defaultCacheBehavior(defaultCacheBehavior.buildAwsValue())
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .bundleId(bundleId: java.lang.String)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDistributionRequest.ReadOnly =
    zio.aws.lightsail.model.CreateDistributionRequest.wrap(buildAwsValue())
}
object CreateDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDistributionRequest =
      zio.aws.lightsail.model.CreateDistributionRequest(
        distributionName,
        origin.asEditable,
        defaultCacheBehavior.asEditable,
        cacheBehaviorSettings.map(value => value.asEditable),
        cacheBehaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bundleId,
        ipAddressType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def distributionName: ResourceName
    def origin: zio.aws.lightsail.model.InputOrigin.ReadOnly
    def defaultCacheBehavior: zio.aws.lightsail.model.CacheBehavior.ReadOnly
    def cacheBehaviorSettings
        : Option[zio.aws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviors
        : Option[List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]]
    def bundleId: String
    def ipAddressType: Option[zio.aws.lightsail.model.IpAddressType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getDistributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionName)
    def getOrigin
        : ZIO[Any, Nothing, zio.aws.lightsail.model.InputOrigin.ReadOnly] =
      ZIO.succeed(origin)
    def getDefaultCacheBehavior
        : ZIO[Any, Nothing, zio.aws.lightsail.model.CacheBehavior.ReadOnly] =
      ZIO.succeed(defaultCacheBehavior)
    def getCacheBehaviorSettings
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheSettings.ReadOnly] =
      AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettings)
    def getCacheBehaviors: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getBundleId: ZIO[Any, Nothing, String] = ZIO.succeed(bundleId)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
  ) extends zio.aws.lightsail.model.CreateDistributionRequest.ReadOnly {
    override val distributionName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.distributionName())
    override val origin: zio.aws.lightsail.model.InputOrigin.ReadOnly =
      zio.aws.lightsail.model.InputOrigin.wrap(impl.origin())
    override val defaultCacheBehavior
        : zio.aws.lightsail.model.CacheBehavior.ReadOnly =
      zio.aws.lightsail.model.CacheBehavior.wrap(impl.defaultCacheBehavior())
    override val cacheBehaviorSettings
        : Option[zio.aws.lightsail.model.CacheSettings.ReadOnly] = scala
      .Option(impl.cacheBehaviorSettings())
      .map(value => zio.aws.lightsail.model.CacheSettings.wrap(value))
    override val cacheBehaviors
        : Option[List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]] =
      scala
        .Option(impl.cacheBehaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.CacheBehaviorPerPath.wrap(item)
          }.toList
        )
    override val bundleId: String = impl.bundleId(): String
    override val ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] =
      scala
        .Option(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
  ): zio.aws.lightsail.model.CreateDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
