package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstanceSnapshotRequest(
    instanceSnapshotName: ResourceName,
    instanceName: ResourceName,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest = {
    import CreateInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
      .builder()
      .instanceSnapshotName(
        ResourceName.unwrap(instanceSnapshotName): java.lang.String
      )
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateInstanceSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateInstanceSnapshotRequest.wrap(buildAwsValue())
}
object CreateInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateInstanceSnapshotRequest =
      zio.aws.lightsail.model.CreateInstanceSnapshotRequest(
        instanceSnapshotName,
        instanceName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceSnapshotName: ResourceName
    def instanceName: ResourceName
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getInstanceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceSnapshotName)
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateInstanceSnapshotRequest.ReadOnly {
    override val instanceSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.instanceSnapshotName())
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest
  ): zio.aws.lightsail.model.CreateInstanceSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
