package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstancesRequest(
    instanceNames: Iterable[String],
    availabilityZone: String,
    customImageName: Option[ResourceName] = None,
    blueprintId: NonEmptyString,
    bundleId: NonEmptyString,
    userData: Option[String] = None,
    keyPairName: Option[ResourceName] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    addOns: Option[Iterable[zio.aws.lightsail.model.AddOnRequest]] = None,
    ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest = {
    import CreateInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
      .builder()
      .instanceNames(instanceNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(
        customImageName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.customImageName)
      .blueprintId(NonEmptyString.unwrap(blueprintId): java.lang.String)
      .bundleId(NonEmptyString.unwrap(bundleId): java.lang.String)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        keyPairName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.keyPairName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateInstancesRequest.ReadOnly =
    zio.aws.lightsail.model.CreateInstancesRequest.wrap(buildAwsValue())
}
object CreateInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateInstancesRequest =
      zio.aws.lightsail.model.CreateInstancesRequest(
        instanceNames,
        availabilityZone,
        customImageName.map(value => value),
        blueprintId,
        bundleId,
        userData.map(value => value),
        keyPairName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value)
      )
    def instanceNames: List[String]
    def availabilityZone: String
    def customImageName: Option[ResourceName]
    def blueprintId: NonEmptyString
    def bundleId: NonEmptyString
    def userData: Option[String]
    def keyPairName: Option[ResourceName]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Option[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]]
    def ipAddressType: Option[zio.aws.lightsail.model.IpAddressType]
    def getInstanceNames: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(instanceNames)
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getCustomImageName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("customImageName", customImageName)
    def getBlueprintId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(blueprintId)
    def getBundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getKeyPairName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("keyPairName", keyPairName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOns)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
  ) extends zio.aws.lightsail.model.CreateInstancesRequest.ReadOnly {
    override val instanceNames: List[String] = impl
      .instanceNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val availabilityZone: String = impl.availabilityZone(): String
    override val customImageName: Option[ResourceName] = scala
      .Option(impl.customImageName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val blueprintId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.blueprintId())
    override val bundleId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.bundleId())
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val keyPairName: Option[ResourceName] = scala
      .Option(impl.keyPairName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns
        : Option[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]] = scala
      .Option(impl.addOns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.AddOnRequest.wrap(item)
        }.toList
      )
    override val ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] =
      scala
        .Option(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest
  ): zio.aws.lightsail.model.CreateInstancesRequest.ReadOnly = new Wrapper(impl)
}
