package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateKeyPairRequest(
    keyPairName: ResourceName,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest = {
    import CreateKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
      .builder()
      .keyPairName(ResourceName.unwrap(keyPairName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateKeyPairRequest.ReadOnly =
    zio.aws.lightsail.model.CreateKeyPairRequest.wrap(buildAwsValue())
}
object CreateKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateKeyPairRequest =
      zio.aws.lightsail.model.CreateKeyPairRequest(
        keyPairName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyPairName: ResourceName
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getKeyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
  ) extends zio.aws.lightsail.model.CreateKeyPairRequest.ReadOnly {
    override val keyPairName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.keyPairName())
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
  ): zio.aws.lightsail.model.CreateKeyPairRequest.ReadOnly = new Wrapper(impl)
}
