package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRelationalDatabaseSnapshotRequest(
    relationalDatabaseName: ResourceName,
    relationalDatabaseSnapshotName: ResourceName,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest = {
    import CreateRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .relationalDatabaseSnapshotName(
        ResourceName.unwrap(relationalDatabaseSnapshotName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotRequest =
      zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotRequest(
        relationalDatabaseName,
        relationalDatabaseSnapshotName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def relationalDatabaseName: ResourceName
    def relationalDatabaseSnapshotName: ResourceName
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getRelationalDatabaseSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseSnapshotName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val relationalDatabaseSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseSnapshotName())
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
  ): zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
