package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteBucketAccessKeyRequest(
    bucketName: BucketName,
    accessKeyId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest = {
    import DeleteBucketAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .accessKeyId(NonEmptyString.unwrap(accessKeyId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteBucketAccessKeyRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteBucketAccessKeyRequest.wrap(buildAwsValue())
}
object DeleteBucketAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteBucketAccessKeyRequest =
      zio.aws.lightsail.model
        .DeleteBucketAccessKeyRequest(bucketName, accessKeyId)
    def bucketName: BucketName
    def accessKeyId: NonEmptyString
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getAccessKeyId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(accessKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
  ) extends zio.aws.lightsail.model.DeleteBucketAccessKeyRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val accessKeyId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.accessKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
  ): zio.aws.lightsail.model.DeleteBucketAccessKeyRequest.ReadOnly =
    new Wrapper(impl)
}
