package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.CertificateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCertificateRequest(certificateName: CertificateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
      .builder()
      .certificateName(
        CertificateName.unwrap(certificateName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteCertificateRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteCertificateRequest.wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteCertificateRequest =
      zio.aws.lightsail.model.DeleteCertificateRequest(certificateName)
    def certificateName: CertificateName
    def getCertificateName: ZIO[Any, Nothing, CertificateName] =
      ZIO.succeed(certificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
  ) extends zio.aws.lightsail.model.DeleteCertificateRequest.ReadOnly {
    override val certificateName: CertificateName =
      zio.aws.lightsail.model.primitives.CertificateName(impl.certificateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
  ): zio.aws.lightsail.model.DeleteCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
