package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContactMethodRequest(
    protocol: zio.aws.lightsail.model.ContactProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest = {
    import DeleteContactMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
      .builder()
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteContactMethodRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteContactMethodRequest.wrap(buildAwsValue())
}
object DeleteContactMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteContactMethodRequest =
      zio.aws.lightsail.model.DeleteContactMethodRequest(protocol)
    def protocol: zio.aws.lightsail.model.ContactProtocol
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.lightsail.model.ContactProtocol] =
      ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
  ) extends zio.aws.lightsail.model.DeleteContactMethodRequest.ReadOnly {
    override val protocol: zio.aws.lightsail.model.ContactProtocol =
      zio.aws.lightsail.model.ContactProtocol.wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
  ): zio.aws.lightsail.model.DeleteContactMethodRequest.ReadOnly = new Wrapper(
    impl
  )
}
