package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContainerImageRequest(
    serviceName: ContainerServiceName,
    image: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest = {
    import DeleteContainerImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .image(image: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteContainerImageRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteContainerImageRequest.wrap(buildAwsValue())
}
object DeleteContainerImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteContainerImageRequest =
      zio.aws.lightsail.model.DeleteContainerImageRequest(serviceName, image)
    def serviceName: ContainerServiceName
    def image: String
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getImage: ZIO[Any, Nothing, String] = ZIO.succeed(image)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
  ) extends zio.aws.lightsail.model.DeleteContainerImageRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val image: String = impl.image(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
  ): zio.aws.lightsail.model.DeleteContainerImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
