package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContainerServiceRequest(
    serviceName: ContainerServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest = {
    import DeleteContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteContainerServiceRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteContainerServiceRequest.wrap(buildAwsValue())
}
object DeleteContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteContainerServiceRequest =
      zio.aws.lightsail.model.DeleteContainerServiceRequest(serviceName)
    def serviceName: ContainerServiceName
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
  ) extends zio.aws.lightsail.model.DeleteContainerServiceRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
  ): zio.aws.lightsail.model.DeleteContainerServiceRequest.ReadOnly =
    new Wrapper(impl)
}
