package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDomainRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteDomainRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteDomainRequest.wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteDomainRequest =
      zio.aws.lightsail.model.DeleteDomainRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
  ) extends zio.aws.lightsail.model.DeleteDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.lightsail.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
  ): zio.aws.lightsail.model.DeleteDomainRequest.ReadOnly = new Wrapper(impl)
}
