package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteInstanceSnapshotRequest(
    instanceSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest = {
    import DeleteInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
      .builder()
      .instanceSnapshotName(
        ResourceName.unwrap(instanceSnapshotName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteInstanceSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteInstanceSnapshotRequest.wrap(buildAwsValue())
}
object DeleteInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteInstanceSnapshotRequest =
      zio.aws.lightsail.model
        .DeleteInstanceSnapshotRequest(instanceSnapshotName)
    def instanceSnapshotName: ResourceName
    def getInstanceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
  ) extends zio.aws.lightsail.model.DeleteInstanceSnapshotRequest.ReadOnly {
    override val instanceSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.instanceSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
  ): zio.aws.lightsail.model.DeleteInstanceSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
