package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteInstanceSnapshotResponse(
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse = {
    import DeleteInstanceSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly =
    zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.wrap(buildAwsValue())
}
object DeleteInstanceSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteInstanceSnapshotResponse =
      zio.aws.lightsail.model.DeleteInstanceSnapshotResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse
  ) extends zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly {
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse
  ): zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
