package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteKnownHostKeysRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest = {
    import DeleteKnownHostKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteKnownHostKeysRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteKnownHostKeysRequest.wrap(buildAwsValue())
}
object DeleteKnownHostKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteKnownHostKeysRequest =
      zio.aws.lightsail.model.DeleteKnownHostKeysRequest(instanceName)
    def instanceName: ResourceName
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
  ) extends zio.aws.lightsail.model.DeleteKnownHostKeysRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest
  ): zio.aws.lightsail.model.DeleteKnownHostKeysRequest.ReadOnly = new Wrapper(
    impl
  )
}
