package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteLoadBalancerTlsCertificateRequest(
    loadBalancerName: ResourceName,
    certificateName: ResourceName,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest = {
    import DeleteLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .certificateName(ResourceName.unwrap(certificateName): java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest =
      zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest(
        loadBalancerName,
        certificateName,
        force.map(value => value)
      )
    def loadBalancerName: ResourceName
    def certificateName: ResourceName
    def force: Option[Boolean]
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
    def getCertificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateName)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
  ) extends zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
    override val certificateName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.certificateName())
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest
  ): zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
