package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRelationalDatabaseSnapshotRequest(
    relationalDatabaseSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest = {
    import DeleteRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
      .builder()
      .relationalDatabaseSnapshotName(
        ResourceName.unwrap(relationalDatabaseSnapshotName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest =
      zio.aws.lightsail.model
        .DeleteRelationalDatabaseSnapshotRequest(relationalDatabaseSnapshotName)
    def relationalDatabaseSnapshotName: ResourceName
    def getRelationalDatabaseSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
  ) extends zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.ReadOnly {
    override val relationalDatabaseSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
  ): zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
