package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachDiskRequest(diskName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachDiskRequest = {
    import DetachDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DetachDiskRequest.ReadOnly =
    zio.aws.lightsail.model.DetachDiskRequest.wrap(buildAwsValue())
}
object DetachDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DetachDiskRequest =
      zio.aws.lightsail.model.DetachDiskRequest(diskName)
    def diskName: ResourceName
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
  ) extends zio.aws.lightsail.model.DetachDiskRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachDiskRequest
  ): zio.aws.lightsail.model.DetachDiskRequest.ReadOnly = new Wrapper(impl)
}
