package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest = {
    import DetachStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
      .builder()
      .staticIpName(ResourceName.unwrap(staticIpName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DetachStaticIpRequest.ReadOnly =
    zio.aws.lightsail.model.DetachStaticIpRequest.wrap(buildAwsValue())
}
object DetachStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DetachStaticIpRequest =
      zio.aws.lightsail.model.DetachStaticIpRequest(staticIpName)
    def staticIpName: ResourceName
    def getStaticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
  ) extends zio.aws.lightsail.model.DetachStaticIpRequest.ReadOnly {
    override val staticIpName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.staticIpName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest
  ): zio.aws.lightsail.model.DetachStaticIpRequest.ReadOnly = new Wrapper(impl)
}
